//
//  MCPTableAliases.h
//  MCFoundation
//
//  Created by Alykhan Jetha on Sun Aug 10 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPEntity;

/*!
	@class MCPTableAliases
	@discussion This class is meant to be used with qualifiers and fetch specifications. The normal mode of operation is singleAliasForTable mode. This forces the creation of one and only one alias for a table (i.e contact will always return t1). You may turn on multi alias mode at any time, but you must revert the back to single alias mode when your qualifier of fetch spec is done. In the event tableAliases went into multi alias mode and then it is reverted back to single alias mode, the first created alias will be returned. The default fromClause is that of OpenBase. If another database is used, you will need to override tableAliasFromClause in a category.


*/


@interface MCPTableAliases : NSObject {

	NSMutableDictionary		*aliases;
	int						mode; 	// 0 = single alias, 1 = multiple alias

	unsigned int			tableAliasCount;

}

- (void)workInSingleAliasForTableMode;
- (void)workInMultipleAliasForTableMode;
- (BOOL)isInMultipleAliasForTableMode;

- (id)tableAliasFromClause;

- (NSString *)tableAliasForEntity:(MCPEntity *)entity;

@end
